<?php

namespace Drupal\prosemirror\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;
use Drupal\prosemirror\ProseMirrorMarkInterface;

/**
 * Defines the ProseMirror mark entity.
 *
 * @ConfigEntityType(
 *   id = "prosemirror_mark",
 *   label = @Translation("ProseMirror mark"),
 *   handlers = {
 *     "list_builder" = "Drupal\prosemirror\ProseMirrorMarkListBuilder",
 *     "form" = {
 *       "add" = "Drupal\prosemirror\Form\ProseMirrorMarkForm",
 *       "edit" = "Drupal\prosemirror\Form\ProseMirrorMarkForm",
 *       "delete" = "Drupal\Core\Entity\EntityDeleteForm"
 *     },
 *     "route_provider" = {
 *       "html" = "Drupal\Core\Entity\Routing\AdminHtmlRouteProvider"
 *     }
 *   },
 *   admin_permission = "administer prosemirror",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *     "uuid" = "uuid"
 *   },
 *   config_export = {
 *     "id",
 *     "label",
 *     "parse_dom",
 *     "to_dom",
 *     "attributes",
 *     "variants"
 *   },
 *   links = {
 *     "add-form" = "/admin/config/content/prosemirror/marks/add",
 *     "edit-form" = "/admin/config/content/prosemirror/marks/{prosemirror_mark}/edit",
 *     "delete-form" = "/admin/config/content/prosemirror/marks/{prosemirror_mark}/delete",
 *     "collection" = "/admin/config/content/prosemirror/marks"
 *   }
 * )
 */
class ProseMirrorMark extends ConfigEntityBase implements ProseMirrorMarkInterface {

  /**
   * The mark ID.
   *
   * @var string
   */
  protected $id;

  /**
   * The mark label.
   *
   * @var string
   */
  protected $label;

  /**
   * The parseDOM rules.
   *
   * @var array
   */
  protected $parse_dom = [];

  /**
   * The toDOM specification.
   *
   * @var array
   */
  protected $to_dom = [];

  /**
   * Additional attributes for this mark.
   *
   * @var array
   */
  protected $attributes = [];

  /**
   * Variants for this mark.
   *
   * @var array
   */
  protected $variants = [];

  /**
   * {@inheritdoc}
   */
  public function getParseDom() {
    return $this->parse_dom;
  }

  /**
   * {@inheritdoc}
   */
  public function getToDom() {
    return $this->to_dom;
  }

  /**
   * {@inheritdoc}
   */
  public function getAttributes() {
    return $this->get('attributes') ?: [];
  }

  /**
   * {@inheritdoc}
   */
  public function getVariants() {
    return $this->get('variants') ?: [];
  }

}
