<?php

namespace Drupal\prosemirror\Plugin;

use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;

/**
 * Plugin manager for ProseMirror Extensions.
 */
class ProseMirrorExtensionManager extends DefaultPluginManager {

  /**
   * Constructs a new ProseMirrorExtensionManager object.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/ProseMirror/Extension', $namespaces, $module_handler, 'Drupal\prosemirror\Plugin\ProseMirrorExtensionInterface', 'Drupal\prosemirror\Annotation\ProseMirrorExtension');

    $this->alterInfo('prosemirror_extension_info');
    $this->setCacheBackend($cache_backend, 'prosemirror_extension_plugins');
  }

  /**
   * Get all extension libraries sorted by weight.
   *
   * @return array
   *   Array of library names.
   */
  public function getExtensionLibraries(): array {
    $libraries = [];
    $extensions = [];

    // Get all extensions and sort by weight.
    foreach ($this->getDefinitions() as $plugin_id => $definition) {
      $extensions[] = [
        'plugin_id' => $plugin_id,
        'weight' => $definition['weight'] ?? 0,
        'libraries' => $definition['libraries'] ?? [],
      ];
    }

    // Sort by weight.
    usort($extensions, function ($a, $b) {
      return $a['weight'] <=> $b['weight'];
    });

    // Collect libraries in weight order.
    foreach ($extensions as $extension) {
      $libraries = array_merge($libraries, $extension['libraries']);
    }

    return array_unique($libraries);
  }

}
