<?php

namespace Drupal\prosemirror;

use Drupal\Core\Config\Entity\ConfigEntityInterface;

/**
 * Provides an interface defining a ProseMirror mark entity.
 */
interface ProseMirrorMarkInterface extends ConfigEntityInterface {

  /**
   * Gets the parseDOM rules for this mark. These are used to parse the HTML/DOM into a ProseMirror document.
   *
   * E.g., a rule to parse a `<strong>` tag into a `bold` mark.
   *
   * @return array
   *   The parseDOM rules array.
   */
  public function getParseDom();

  /**
   * Gets the toDOM specification for this mark. These are used to render the ProseMirror document into HTML/DOM.
   *
   * E.g., a rule to render a `bold` mark into a `<strong>` tag.
   *
   * @return array
   *   The toDOM specification array.
   */
  public function getToDom();

  /**
   * Gets additional attributes for this mark.
   *
   * @return array
   *   The attributes array.
   */
  public function getAttributes();

  /**
   * Gets the variants for this mark.
   *
   * @return array
   *   The variants array.
   */
  public function getVariants();

}
