<?php

namespace Drupal\prosemirror\Rendering\Plugin;

use Drupal\Core\Plugin\PluginBase;
use Drupal\prosemirror\Rendering\ProseMirrorRenderer;

/**
 * Base class for ProseMirror rendering plugins.
 */
abstract class ProseMirrorRenderingPluginBase extends PluginBase implements ProseMirrorRenderingPluginInterface {

  /**
   * {@inheritdoc}
   */
  public function getNodeTypes(): array {
    return $this->pluginDefinition['node_types'] ?? [];
  }

  /**
   * {@inheritdoc}
   */
  public function getSupportedFormats(): array {
    return $this->pluginDefinition['formats'] ?? ['html'];
  }

  /**
   * Checks if this plugin supports the given format.
   *
   * @param string $format
   *   The format to check.
   *
   * @return bool
   *   TRUE if supported, FALSE otherwise.
   */
  protected function supportsFormat(string $format): bool {
    return in_array($format, $this->getSupportedFormats());
  }

  /**
   * Renders child content.
   *
   * @param array $content
   *   The content array.
   * @param string $format
   *   The target format.
   * @param \Drupal\prosemirror\Rendering\ProseMirrorRenderer $renderer
   *   The renderer service.
   *
   * @return array
   *   Array of rendered children.
   */
  protected function renderChildren(array $content, string $format, ProseMirrorRenderer $renderer): array {
    return $renderer->renderChildren($content, $format);
  }

}
