<?php

namespace Drupal\prosemirror\Rendering\Plugin;

use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;

/**
 * Provides the ProseMirror rendering plugin manager.
 */
class ProseMirrorRenderingPluginManager extends DefaultPluginManager {

  /**
   * Constructs a new ProseMirrorRenderingPluginManager object.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct(
      'Plugin/ProseMirror/Rendering',
      $namespaces,
      $module_handler,
      'Drupal\prosemirror\Rendering\Plugin\ProseMirrorRenderingPluginInterface',
      'Drupal\prosemirror\Annotation\ProseMirrorRenderingPlugin'
    );

    $this->alterInfo('prosemirror_rendering_plugin_info');
    $this->setCacheBackend($cache_backend, 'prosemirror_rendering_plugins');
  }

  /**
   * Gets plugins sorted by weight.
   *
   * @return array
   *   Plugin definitions sorted by weight.
   */
  public function getDefinitionsSorted(): array {
    $definitions = $this->getDefinitions();

    // Sort by weight.
    uasort($definitions, function ($a, $b) {
      return ($a['weight'] ?? 0) <=> ($b['weight'] ?? 0);
    });

    return $definitions;
  }

}
