## Introduction

A [ProseMirror](https://prosemirror.net/)-based rich text editor for Drupal, providing a modular, extensible foundation for rich text editing.

Compared to CKEditor:
- ProseMirror provides better headless, decoupled, and omnichannel content editing capabilities.
- ProseMirror is very easy to extend with custom elements and marks.
- ProseMirror is fully open-source with no dual license and no restricted features.

### Why is ProseMirror better suited for headless, decoupled, and omnichannel publishing?

The ProseMirror module stores content as **structured data** instead of HTML. While HTML is simpler for content that's used strictly within Drupal, it's very limiting for use cases outside of Drupal:
1. **Links to other content use Drupal routes.**
  - This makes it very difficult to use custom routing in frontends.
  - ProseMirror's structured data makes it easy to decide in the frontend how to render and open links.
2. **Media is embedded as a <drupal-media>**
  - This makes it difficult to take control of media embedding and rendering in frontends.
  - ProseMirror's structured data makes it easy to decide in the frontend how to embed and render media assets.
3. **Images use relative file system URLs**
  - This makes it difficult to work with assets as files are not a first-class citizen.
  - ProseMirror's structured data makes it easy to decide in the frontend how to render images. We recommend using CDNs to add image optimization options for frontend development to work independently of Drupal's image styles.
4. **Opinionated HTML structure**
  - While the HTML structure from Drupal is usually fine for web-based rendering, there are use cases where a more specific HTML output is required, e.g., for rendering content in emails.
  - ProseMirror's structured data allows the frontend or integration handler to decide how to render each element and mark.
5. **Full HTML support is expected**
  - While the HTML structure from Drupal is usually fine for web-based rendering, there are use cases where not all elements and marks are available. E.g., a Digital Signage may not be able to display links and a renderer in a native app must be able to map elements and marks to natively constructed components.
  - ProseMirror's structured data makes it easy for non-web renderers to map elements and marks to native components.

The ProseMirror module ships with a default renderer for HTML, so from an editor perspective it doesn't behave any different and you don't have to write any custom code for displaying rich text either. The biggest difference is in how rich text is provided to external clients, e.g., those using {JSON:API}. Take a look at the `ProseMirror {JSON:API} Example` below to see what it looks like for consumers and frontend developers.

## Migrating from CKEditor

ProseMirror provides a parser for CKEditor-created content out of the box. Simply switching from a CKEditor-based text format to a ProseMirror-based text format will translate your existing HTML-structured content to the ProseMirror-based rich text structure (stored as JSON).

## Requirements

ProseMirror does not have requirements for other modules.

## Installation

After adding the module to your site, install it using drush or the Drupal Extend UI. Please consider installing the `prosemirror_defaults` submodule as well (see Configuration below).

After configuring what elements and marks are available, either create a new text format or update an existing text format to use the ProseMirror editor instead of the CKEditor.

## Configuration

If you're new to ProseMirror, we strongly recommend installing the `prosemirror_defaults` submodule that comes with the main `prosemirror` module. This will create default element groups, elements and marks. Without configuration, the editor will not load.

If you want to use autocomplete suggestions for content links, install the `linkit` module and create one or more of the following profiles:
- `prosemirror_content` for node content.
- `prosemirror_media` for media content.
- `prosemirror_block_content` for block content.

The rich text may not render fully inside of Drupal unless all used HTML elements and attributes are allowed. If you want to allow everything that the editor can potentially produce, it would require a configuration like the following. **Please double check which of the following attributes you want users to customize using the editor, especially for CSS classes.**:

```html
<em> <strong> <cite> <blockquote cite> <code> <ul type> <ol start type> <li> <dl> <dt> <dd> <h1> <h2 id> <h3 id> <h4 id> <h5 id> <h6 id> <img src alt data-entity-type data-entity-uuid data-align data-caption> <a href hreflang data-entity-type data-entity-uuid class> <drupal-media data-entity-type data-entity-uuid data-view-mode data-align data-caption alt title> <i class> <sub> <sup> <small> <u> <table> <thead> <tbody> <tr> <th> <td> <div class> <s>
```

The following configuration options are available.

### Elements
Elements are typically blocks of content. Elements can opt-in to having children (like the text for a headline) or they can be standalone with no children allowed (like media or a horizontal line).

#### System elements
When installing the main `prosemirror` module, the following system elements are available:
- `doc` *required*: The root document. This is always the first block inside a document and it cannot appear anywhere else.
- `text` *required*: Unformatted text. Marks (like `bold` or `italic`) for example have text children where the mark determines how to render the child. Without a mark, text is rendered as plain text using the default font, size, color, text weight and no decorations.
- `media` *optional*: A media item from Drupal's media library, e.g., rendered as `<media>`.
- `code_block` *optional*: A block of code, e.g., rendered as `<code>`.
  - Code blocks can be configured to allow a specific set of languages for syntax highlighting in your frontends.
- `table` *optional*: A table. Can only have `table_row` children, e.g., rendered as `<table>`.
  - Tables can be configured to only have a maximum number of rows and columns.
  - Tables can be configured to allow or not allow table headers (usually the first row or column of a table).
- `table_row` *optional*: A table row. Can only be placed inside a `table` parent. Can only have `table_cell` and `table_header` children. E.g., rendered as `<tr>`.
- `table_cell` *optional*: A table cell. Can only be placed inside a `table_row` parent. E.g., rendered as `<td>`.
- `table_header` *optional*: A table header. Typically in the first row or column of a table. Can only be placed inside a `table_row` parent.  E.g., rendered as `<th>`.
- `bullet_list` *optional*: A list of bullet items, e.g., rendered as `<ul>`. Can only have `list_item` children.
- `ordered_list` *optional*: A list of items with an incrementing prefix, e.g., rendered as `<ol>`. Can only have `list_item` children.
- `list_item` *optional*: An individual item in a list, e.g., rendered as `<li>`. Can only be placed inside `bullet_list` and `ordered_list` parents.
- `heading` *optional*: Render a headline, e.g., `<h1>` or `<h2>`.

**If you don't want to use some of these system elements, you can simply not add them to the text format and corresponding element group configurations (see below).**

#### Default elements
When installing the `prosemirror_defaults` module, the following elements are created by default:
- Examples for standard text blocks:
  - `paragraph`: Standard element for rendering inline text inside of it (e.g., `<p>`).
  - `blockquote`: Standard element for rendering quotes inside of it (e.g., `<blockquote>`).
  - `hr`: Standard element for rendering a horizontal ruler, not allowing children (e.g., `<hr/>`).
  - `heading_*`: Standard elements for rendering headlines 1-6 with text inside of it (e.g., `<h1>` or `<h2>`).
- Examples for custom blocks:
  - `steps`: Render a list of `step` blocks, e.g., for providing user instructions.
  - `step`: Render an individual step inside a `steps` parent.
  - `columns`: Render a list of `column` blocks.
  - `column`: Render an individual column inside a `columns` parent.

**You can delete any element you don't need after installing the `prosemirror_defaults` module.** You can also freely configure custom element types.

Some elements can have additional properties like a `name` and `variant`:
- E.g., a step can have a step name.
- E.g., a code block can have a file name.
- E.g., a code block can have programming languages as variants.
- E.g., an info box may have variants for `error`, `warning`, and `info`.

Parent elements can restrict editing of children in several ways:
- Decide what blocks are allowed underneath it.
  - E.g., a `columns` element only allows `column` children.
- Decide how many elements are allowed underneath it.
  - E.g., a `columns` element may only allow up to 3 children.
  - E.g., a `table-row` element may only alllow up to 3 columns as children.

These restrictions are important considerations when you create the content model for a Drupal site. To support rendering across different device types, applications, and frontend languages, it's important to consider what all of their combined capabilities are and what restrictions are necessary to ensure consistent high-quality content delivery across all devices and touchpoints.

### Marks
While elements allow you to configure **blocks** of content, marks allow you to configure **inline** content.

Marks cannot have children, but multiple marks can be applied similtaneously. Consider the following HTML-based examples:
- `<strong>example</strong>` would have a `bold` mark for `example` text content.
- `<strong><em>example</em></strong>` would have a `bold` and an `italic` mark for `example` text content.
- `<strong>this <em>example</em></strong>` would have a `bold` mark for `this ` text content and then an `bold` and `italic` mark for `example` text content.

When installing the `prosemirror_defaults` module, the following marks are created by default:
- `italic`: Render text content as italic, e.g., `<em>` or `<i>`.
- `bold`: Render text content as bold, e.g., `<strong>` or `<b>`.
- `link`: Render text content as a link, e.g., `<a>`. Links can either be an internal link pointing to other content, e.g., another article, or be an external link pointing to resources outside of the CMS like an absolute URL to another website.
  - You can configure variants for links, e.g., to render some links as `primary buttons`, `secondary buttons`, or regular `links`.
- `code`: Render text content as code, e.g., `<code>`. This is strictly for *inline* text `like what you see here`. You can also configure a `codeblock` *element* to render code as a full block (usually with syntax highlighting).
- `strike`: Render text content with a line stricken through it, e.g., `<s>` or `<strike>`.
- `underline`: Render text content with an underline, e.g., `<u>`.
- `small`: Render text content with a smaller font, e.g., `<small>`.
- `subscript`: Render text content vertically below other text content, e.g., `<sub>`.
- `superscript`: Render text content vertically above other text content, e.g., `<sup>`.

**You can delete any mark you don't need after installing the `prosemirror_defaults` module.** You can also freely configure custom mark types.

### Element groups
Element groups are categories for elements. ProseMirror allows you to restrict what element can be a child of what other element. E.g., a headline doesn't expect to have a column as a child and will only allow `inline` (text) as children.
Elements can be assigned to any number of element groups. When creating a parent element (a `block`), you can decide what element group is allowed to be placed inside that block.
When installing the `prosemirror_defaults` module, the following element groups are created by default:
- `nested`: Blocks that only allow other blocks as children, usually strongly typed.
  - E.g. a `columns` container expecting `column` children.
- `leaf_block`: A leaf block that contains no other blocks and only allows inline content like media or text.
  - E.g. a `column` block that's allowed inside specific parents like `columns`.
  - E.g. a `info-box` block that allows text and media inside of it, but not another block.
- `leaf`: A leaf; same as `inline` but not for the built-in text type, so requires a "paragraph" in-between.
  - E.g. a `paragraph` for a simple text paragraph (HTML: `<p>`).
  - E.g. a `blockquote` to be rendered as a quote.
  - E.g. a `heading_*` to be rendered as headlines (HTML: `<h1>`, `<h2>`, ...).
  - E.g. an `horizontal ruler` (`<hr/>`) that allows no children.
- `inline`: Any inline element, including text; used by "paragraph" usually.
- `block`: Any kind of block, whether nested or not.

**You can delete any element group you don't need after installing the `prosemirror_defaults` module.** You can also freely configure custom element groups to create custom content placement validations.

### Text format

To see the ProseMirror editor when editing, you have to first assign it to a text format. In Drupal, navigate to Administration > Configuration > Content authoring > Text formats and editors. You can either edit an existing text format or create a new text format from scratch and assign the ProseMirror editor to it.

You can decide per filter which elements and marks are allowed. If you check no elements/marks, all available elements/marks are allowed.

After assigning the ProseMirror editor, you will notice that a mandatory *ProseMirror Content Renderer* is added as the first filter to the text format. This filter will translate the structured data into HTML and is used for rendering content inside of Drupal. When querying for content using JSON:API, the processed HTML is available under `field_body[0]["processed"]`; to create a custom frontend rendering, access the JSON under `field_body[0]["value"]` instead.

## Extensibility
The ProseMirror module provides various APIs to interact with the system, allowing you to create custom elements, marks, etc. You can extend both the **Drupal** part of ProseMirror and the **JavaScript editor** part. Please take a look at the services defined in `prosemirror.services.yml` to learn more or install the `prosemirror_fontawesome_icons` module from drupal.org to see a real-world example.

## ProseMirror {JSON:API} Example

*The code below is using the `prosemirror_api_field` submodule that adds a virtual field for text fields with an optimized data structure.*

```json
{
  "data": {
    "type": "node--article",
    "id": "123e4567-e89b-12d3-a456-426614174000",
    "attributes": {
      "body_prosemirror": {
        "processed": "<div class=\"ProseMirror-rendered\"><p>Hello <a href=\"/node/1\">world</a></p></div>",
        "value": {
          "type": "doc",
          "content": [
            {
              "type": "paragraph",
              "content": [
                {
                  "type": "text",
                  "text": "Hello "
                },
                {
                  "type": "text",
                  "text": "world",
                  "marks": [
                    {
                      "type": "link",
                      "attrs": {
                        "linkType": "internal",
                        "entityType": "node",
                        "entityUuid": "550e8400-e29b-41d4-a716-446655440000",
                        "href": "entity:node/550e8400-e29b-41d4-a716-446655440000"
                      }
                    }
                  ]
                }
              ]
            }
          ]
        },
        "included": [
          {
            "type": "node--page",
            "id": "550e8400-e29b-41d4-a716-446655440000",
            "meta": {
              "drupal_internal__target_id": 1,
              "label": "Referenced Node Title"
            }
          }
        ]
      }
    }
  }
}
```

## Maintainers

The ProseMirror is sponsored and maintained by [Content Sync](https://www.content-sync.io/).

While ProseMirror is the recommended editor for working with Content Sync's [Content Cloud](https://www.content-sync.io/content-cloud/), the ProseMirror module is fully open source, has no usage restrictions, and works completely independent of any commercial services.

If you would like to contribute, please create an issue in the Issue Queue on drupal.org. As a Content Sync customer, please create a ticket in the Content Sync helpdesk to receive SLA coverage.
