export interface ElementAttributes {
  id?: string;
  className?: string;
  style?: Partial<CSSStyleDeclaration>;
  dataset?: Record<string, string>;
  attributes?: Record<string, string>;
  listeners?: Record<string, EventListener>;
}

export interface InputAttributes extends ElementAttributes {
  type?: string;
  placeholder?: string;
  value?: string;
  required?: boolean;
  name?: string;
  autocomplete?: string;
}

export interface SelectOption {
  value: string;
  label: string;
  selected?: boolean;
}

export interface ButtonAttributes extends ElementAttributes {
  disabled?: boolean;
}

export interface RenderResult<T extends HTMLElement = HTMLElement> {
  element: T;
  destroy?: () => void;
  update?: (attrs: any) => void;
}

export interface ElementRenderer {
  div(attrs?: ElementAttributes): RenderResult<HTMLDivElement>;
  span(attrs?: ElementAttributes): RenderResult<HTMLSpanElement>;
  input(attrs?: InputAttributes): RenderResult<HTMLInputElement>;
  button(text: string, attrs?: ButtonAttributes): RenderResult<HTMLButtonElement>;
  label(text: string, attrs?: ElementAttributes & { for?: string }): RenderResult<HTMLLabelElement>;
  select(options: SelectOption[], attrs?: ElementAttributes): RenderResult<HTMLSelectElement>;
  form(attrs?: ElementAttributes): RenderResult<HTMLFormElement>;
}

export interface TooltipConfig {
  content: string | HTMLElement;
  position?: { x: number; y: number };
  className?: string;
  interactive?: boolean;
}

export interface DialogConfig {
  title: string;
  content: HTMLElement;
  buttons?: Array<{
    text: string;
    action: () => void;
    primary?: boolean;
  }>;
  width?: string | number;
  height?: string | number;
  modal?: boolean;
}

export interface AutocompleteConfig {
  placeholder?: string;
  value?: string;
  required?: boolean;
  onQuery: (term: string) => Promise<AutocompleteItem[]>;
  onSelect: (item: AutocompleteItem) => void;
}

export interface AutocompleteItem {
  value: string;
  label: string;
  description?: string;
  group?: string;
  metadata?: Record<string, any>;
}

export interface ComponentRenderer {
  tooltip(config: TooltipConfig): RenderResult<HTMLElement>;
  dialog(config: DialogConfig): RenderResult<HTMLElement> & { open: () => void; close: () => void };
  autocomplete(config: AutocompleteConfig): RenderResult<HTMLElement>;
}

export interface RendererFactory {
  elements: ElementRenderer;
  components: ComponentRenderer;
} 