export interface DialogInstance {
  close: () => void;
}

export interface MediaAttributes {
  'data-entity-type': string;
  'data-entity-uuid': string;
  updatedAt?: number;
}

export interface DialogSettings {
  title: string;
  width?: string | number;
  height?: string | number;
  dialogClass?: string;
  autoResize?: boolean;
  resizable?: boolean;
  draggable?: boolean;
  modal?: boolean;
}

export interface AutocompleteItem {
  status: string;
  label: string;
  description?: string;
  entity_type_id: string;
  entity_uuid: string;
  group?: string;
  path: string;
  substitution_id?: string;
}

export interface AutocompleteFieldOptions {
  label: string;
  placeholder?: string;
  value?: string;
  required?: boolean;
}

/**
 * Interface for application-specific functionality.
 */
export interface ApplicationWrapper {
  /**
   * Select media from the media library
   */
  selectMedia(callback: (attributes: MediaAttributes) => void): void;

  /**
   * Open a custom dialog with HTML content
   */
  openCustomDialog(content: HTMLElement, saveCallback: (data: any) => void, dialogSettings: DialogSettings): DialogInstance;

  /**
   * Make an AJAX request
   */
  ajax(options: {
    url: string;
    type?: string;
    data?: any;
    dataType?: string;
    success?: (response: any) => void;
    error?: (error: any) => void;
  }): void;

    /**
   * Get media preview
   */
  getMediaPreview(uuid: string): Promise<{ preview: string, label: string | null }>;

  /**
   * Get element value (for form fields)
   */
  getElementValue(element: HTMLTextAreaElement): string;

  /**
   * Set element value (for form fields)
   */
  setElementValue(element: HTMLTextAreaElement, value: string): void;

  /**
   * Parse HTML string into DOM element
   */
  parseHTML(html: string): HTMLElement;

  /**
   * Add a document event listener (e.g., for click events on the document).
   */
  addDocumentEventListener(event: string, callback: (event: Event, ...args: any[]) => void): void;

  /**
   * Remove a document event listener.
   */
  removeDocumentEventListener(event: string, callback: (event: Event, ...args: any[]) => void): void;

  /**
   * Get the renderer factory for creating UI elements
   */
  getRendererFactory(): import('../renderers/interfaces').RendererFactory;
}
