# ProseMirror API Field

This submodule adds computed fields for enhanced JSON:API support of ProseMirror content.

## What it does

For every text field (text, text_long, text_with_summary) on your entities, this module automatically adds a corresponding `{field_name}_prosemirror` computed field that provides:

- **`processed`**: Rendered HTML using ProseMirror renderer
- **`value`**: Parsed ProseMirror document structure as JSON
- **`included`**: Entity references in JSON:API resource identifier format

## Example

If you have a `body` field, this module will add a `body_prosemirror` field that contains:

```json
{
  "body_prosemirror": {
    "processed": "<div class=\"ProseMirror-rendered\"><p>Hello world</p></div>",
    "value": {
      "type": "doc",
      "content": [
        {
          "type": "paragraph",
          "content": [{"type": "text", "text": "Hello world"}]
        }
      ]
    },
    "included": [
      {
        "type": "node--page",
        "id": "<uuid>",
        "meta": {
          "drupal_internal__target_id": 1,
          "label": "Referenced Node"
        }
      }
    ]
  }
}
```

## JSON:API Usage

```bash
# Get enhanced ProseMirror data
curl "http://example.com/jsonapi/node/article?fields[node--article]=body,body_prosemirror"

# Get only the enhanced data
curl "http://example.com/jsonapi/node/article?fields[node--article]=body_prosemirror"
```

## Installation

This is an optional submodule. Enable it only if you need enhanced JSON:API support for ProseMirror content:

```bash
drush en prosemirror_api_field
```

## Dependencies

- ProseMirror core module
- JSON:API module (core)
