<?php

declare(strict_types=1);

namespace Drupal\Tests\prosemirror_api_field\Unit\Field;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityRepositoryInterface;
use Drupal\Core\Field\BaseFieldDefinition;
use Drupal\Core\Field\FieldItemInterface;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\prosemirror_api_field\Field\ProseMirrorComputedFieldItemList;
use Drupal\prosemirror\Rendering\ProseMirrorRendererInterface;
use Drupal\prosemirror\Transformation\ElementInstance;
use Drupal\prosemirror\Transformation\EntityReference;
use Drupal\prosemirror\Transformation\TransformationHelper;
use Drupal\Tests\UnitTestCase;
use Prophecy\PhpUnit\ProphecyTrait;
use Symfony\Component\DependencyInjection\ContainerBuilder;

/**
 * Tests the ProseMirrorComputedFieldItemList.
 *
 * @group prosemirror_api_field
 * @coversDefaultClass \Drupal\prosemirror_api_field\Field\ProseMirrorComputedFieldItemList
 */
class ProseMirrorComputedFieldItemListTest extends UnitTestCase {

  use ProphecyTrait;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
  }

  /**
   * Tests that the computed field class exists and can be instantiated.
   */
  public function testComputedFieldClassExists(): void {
    $this->assertTrue(class_exists(ProseMirrorComputedFieldItemList::class));
  }

  /**
   * Tests that the computed field uses the ComputedItemListTrait.
   */
  public function testUsesComputedItemListTrait(): void {
    $reflection = new \ReflectionClass(ProseMirrorComputedFieldItemList::class);
    $traits = $reflection->getTraitNames();
    $this->assertContains('Drupal\Core\TypedData\ComputedItemListTrait', $traits);
  }

  /**
   * Tests that the computed field extends FieldItemList.
   */
  public function testExtendsFieldItemList(): void {
    $reflection = new \ReflectionClass(ProseMirrorComputedFieldItemList::class);
    $this->assertTrue($reflection->isSubclassOf('Drupal\Core\Field\FieldItemList'));
  }

}
