<?php

namespace Drupal\prosemirror\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines a ProseMirror element type plugin annotation object.
 *
 * @see \Drupal\prosemirror\Plugin\ProseMirrorElementTypeManager
 * @see plugin_api
 *
 * @Annotation
 */
class ProseMirrorElementType extends Plugin {

  /**
   * The plugin ID.
   *
   * @var string
   */
  public $id;

  /**
   * The human-readable name of the element type.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $label;

  /**
   * A short description of the element type.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $description;

}
