<?php

namespace Drupal\prosemirror\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Url;
use Symfony\Component\HttpFoundation\RedirectResponse;

/**
 * Returns responses for ProseMirror admin routes.
 *
 * - Contains redirects to the settings page when opening the default route.
 */
class ProseMirrorAdminController extends ControllerBase {

  /**
   * Redirects to the settings page.
   *
   * @return \Symfony\Component\HttpFoundation\RedirectResponse
   *   A redirect response to the settings page.
   */
  public function redirectToSettings() {
    $url = Url::fromRoute('prosemirror.settings');
    return new RedirectResponse($url->toString());
  }

}
