<?php

namespace Drupal\prosemirror\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;
use Drupal\prosemirror\ProseMirrorElementGroupInterface;

/**
 * Defines the ProseMirror element group entity.
 *
 * @ConfigEntityType(
 *   id = "prosemirror_element_group",
 *   label = @Translation("ProseMirror element group"),
 *   handlers = {
 *     "list_builder" = "Drupal\prosemirror\ProseMirrorElementGroupListBuilder",
 *     "form" = {
 *       "add" = "Drupal\prosemirror\Form\ProseMirrorElementGroupForm",
 *       "edit" = "Drupal\prosemirror\Form\ProseMirrorElementGroupForm",
 *       "delete" = "Drupal\Core\Entity\EntityDeleteForm"
 *     },
 *     "route_provider" = {
 *       "html" = "Drupal\Core\Entity\Routing\AdminHtmlRouteProvider"
 *     }
 *   },
 *   admin_permission = "administer prosemirror",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *     "uuid" = "uuid"
 *   },
 *   config_export = {
 *     "id",
 *     "label"
 *   },
 *   links = {
 *     "add-form" = "/admin/config/content/prosemirror/element-groups/add",
 *     "edit-form" = "/admin/config/content/prosemirror/element-groups/{prosemirror_element_group}/edit",
 *     "delete-form" = "/admin/config/content/prosemirror/element-groups/{prosemirror_element_group}/delete",
 *     "collection" = "/admin/config/content/prosemirror/element-groups"
 *   }
 * )
 */
class ProseMirrorElementGroup extends ConfigEntityBase implements ProseMirrorElementGroupInterface {

  /**
   * The element group ID.
   *
   * @var string
   */
  protected $id;

  /**
   * The element group label.
   *
   * @var string
   */
  protected $label;

  /**
   * {@inheritdoc}
   */
  public function getElements() {
    /** @var \Drupal\prosemirror\Element\ElementProvider $element_provider */
    $element_provider = \Drupal::service('prosemirror.element_provider');
    $all_elements = $element_provider->getAllElements();

    $group_elements = [];
    foreach ($all_elements as $element) {
      if (in_array($this->id(), $element->getGroups())) {
        $group_elements[$element->id()] = $element;
      }
    }

    return $group_elements;
  }

}
