<?php

namespace Drupal\prosemirror\Plugin\ProseMirror\Rendering;

use Drupal\prosemirror\Rendering\Plugin\ProseMirrorRenderingPluginBase;
use Drupal\prosemirror\Rendering\ProseMirrorRenderer;

/**
 * Renders list block elements.
 *
 * @ProseMirrorRenderingPlugin(
 *   id = "list_block",
 *   label = @Translation("List Block Renderer"),
 *   description = @Translation("Renders list block elements with direction support."),
 *   node_types = {"list_block"},
 *   formats = {"html"},
 *   weight = 50
 * )
 */
class ListBlockRenderer extends ProseMirrorRenderingPluginBase {

  /**
   * {@inheritdoc}
   */
  public function render(array $node, array &$renderArray, string $format, ProseMirrorRenderer $renderer): bool {
    if (!$this->supportsFormat($format)) {
      return FALSE;
    }

    $attrs = $node['attrs'] ?? [];
    $direction = $attrs['direction'] ?? 'column';
    $name = $attrs['name'] ?? '';

    // Render child content.
    $children = [];
    if (isset($node['content']) && is_array($node['content'])) {
      $children = $this->renderChildren($node['content'], $format, $renderer);
    }

    $classes = ['pm-list-block', 'pm-direction-' . $direction];

    $renderArray = [
      '#type' => 'html_tag',
      '#tag' => 'div',
      '#attributes' => ['class' => $classes],
      'children' => $children,
    ];

    // Add header if name is provided.
    if (!empty($name)) {
      $renderArray['header'] = [
        '#type' => 'html_tag',
        '#tag' => 'div',
        '#attributes' => ['class' => ['pm-list-block-header']],
        '#value' => $name,
        '#weight' => -10,
      ];
    }

    // Attach CSS library.
    $renderArray['#attached']['library'][] = 'prosemirror/html-rendering';

    return TRUE;
  }

}
