<?php

namespace Drupal\prosemirror\Plugin;

use Drupal\Component\Plugin\PluginBase;

/**
 * Base class for ProseMirror Extension plugins.
 */
abstract class ProseMirrorExtensionBase extends PluginBase implements ProseMirrorExtensionInterface {

  /**
   * {@inheritdoc}
   */
  public function getLibraries(): array {
    return $this->pluginDefinition['libraries'] ?? [];
  }

  /**
   * {@inheritdoc}
   */
  public function getWeight(): int {
    return $this->pluginDefinition['weight'] ?? 0;
  }

}
