<?php

namespace Drupal\prosemirror\Plugin\Validation\Constraint;

use Symfony\Component\Validator\Constraint;

/**
 * ProseMirror content validation constraint.
 *
 * @Constraint(
 *   id = "ProseMirrorContent",
 *   label = @Translation("ProseMirror content validation", context = "Validation"),
 *   type = "string"
 * )
 */
class ProseMirrorContentConstraint extends Constraint {

  /**
   * The error message for invalid ProseMirror content.
   *
   * @var string
   */
  public $invalidContent = 'The ProseMirror content contains validation errors. This is likely a technical issue with the editor.';

}
