<?php

namespace Drupal\prosemirror;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Url;

/**
 * Provides a listing of ProseMirror element group entities.
 */
class ProseMirrorElementGroupListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['label'] = $this->t('Group');
    $header['id'] = $this->t('Machine name');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    /** @var \Drupal\prosemirror\ProseMirrorElementGroupInterface $entity */
    $row['label'] = $entity->label();
    $row['id'] = $entity->id();
    return $row + parent::buildRow($entity);
  }

  /**
   * {@inheritdoc}
   */
  public function render() {
    $build = parent::render();

    // Add the "Add group" action link.
    $build['table']['#empty'] = $this->t('No ProseMirror element groups available. <a href=":link">Add group</a>.', [
      ':link' => Url::fromRoute('entity.prosemirror_element_group.add_form')->toString(),
    ]);

    return $build;
  }

}
