<?php

namespace Drupal\prosemirror;

use Drupal\Core\Config\Entity\ConfigEntityInterface;

/**
 * Provides an interface for defining ProseMirror elements.
 */
interface ProseMirrorElementInterface extends ConfigEntityInterface {

  /**
   * Gets the element type plugin ID.
   *
   * @return string
   *   The element type plugin ID.
   */
  public function getType();

  /**
   * Gets the CSS classes for rendering the element.
   *
   * @return array
   *   The CSS classes.
   */
  public function getCssClasses();

  /**
   * Gets the allowed content (by element group).
   *
   * @return string
   *   The allowed content.
   */
  public function getContent();

  /**
   * Gets the minimum content count for the element for parent elements.
   *
   * @return int|null
   *   The minimum item count.
   */
  public function getContentMin();

  /**
   * Gets the maximum content count for the element for parent elements.
   *
   * @return int|null
   *   The maximum item count.
   */
  public function getContentMax();

  /**
   * Gets the element groups the element belongs to. Whenever any of the given element groups are allowed, this element is allowed.
   *
   * @return array
   *   The element groups.
   */
  public function getGroups();

  /**
   * Gets any additional options for the element.
   *
   * @return array
   *   The additional options.
   */
  public function getOptions();

  /**
   * Gets the content expression for ProseMirror schema (e.g., '+', '*', '{1,4}').
   *
   * @return string
   *   The content expression.
   */
  public function getContentExpression();

}
