<?php

namespace Drupal\prosemirror;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Url;

/**
 * Provides a listing of ProseMirror elements.
 */
class ProseMirrorElementListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['label'] = $this->t('Element');
    $header['id'] = $this->t('Machine name');
    $header['type'] = $this->t('Type');
    $header['groups'] = $this->t('Groups');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    /** @var \Drupal\prosemirror\ProseMirrorElementInterface $entity */
    $row['label'] = $entity->label();
    $row['id'] = $entity->id();
    $row['type'] = $entity->getType();
    $row['groups'] = implode(', ', $entity->getGroups());
    return $row + parent::buildRow($entity);
  }

  /**
   * {@inheritdoc}
   */
  public function render() {
    $build = parent::render();

    // Add the "Add element" action link.
    $build['table']['#empty'] = $this->t('No ProseMirror elements available. <a href=":link">Add element</a>.', [
      ':link' => Url::fromRoute('entity.prosemirror_element.add_form')->toString(),
    ]);

    return $build;
  }

}
