<?php

namespace Drupal\prosemirror;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Component\Utility\Html;

/**
 * Provides a listing of ProseMirror marks.
 */
class ProseMirrorMarkListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['label'] = $this->t('Mark');
    $header['id'] = $this->t('Machine name');
    $header['description'] = $this->t('Description');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    $row['label'] = $entity->label();
    $row['id'] = $entity->id();

    // Build a description from the parseDOM rules.
    $parse_dom = $entity->getParseDom();
    $tags = [];
    $styles = [];

    foreach ($parse_dom as $rule) {
      if (isset($rule['tag'])) {
        // HTML-escaped by Drupal when rendered.
        $tags[] = '<' . $rule['tag'] . '>';
      }
      if (isset($rule['style'])) {
        $styles[] = $rule['style'];
      }
    }

    $description_parts = [];

    if (!empty($tags)) {
      $description_parts[] = $this->t('Tags: %tags', ['%tags' => implode(', ', $tags)]);
    }

    if (!empty($styles)) {
      $description_parts[] = $this->t('Styles: %styles', ['%styles' => implode(', ', $styles)]);
    }

    if (!empty($description_parts)) {
      $row['description'] = [
        'data' => [
          '#markup' => implode(' | ', $description_parts),
        ],
      ];
    }
    else {
      $row['description'] = $this->t('No rules defined');
    }

    return $row + parent::buildRow($entity);
  }

}
