<?php

namespace Drupal\prosemirror\Rendering\Plugin;

use Drupal\Component\Plugin\PluginInspectionInterface;
use Drupal\prosemirror\Rendering\ProseMirrorRenderer;

/**
 * Interface for ProseMirror rendering plugins.
 */
interface ProseMirrorRenderingPluginInterface extends PluginInspectionInterface {

  /**
   * Renders a node to a render array.
   *
   * @param array $node
   *   The node data to render.
   * @param array &$renderArray
   *   The render array to populate. The plugin should modify this array.
   * @param string $format
   *   The target format (e.g., 'html', 'markdown', 'plain_text').
   * @param \Drupal\prosemirror\Rendering\ProseMirrorRenderer $renderer
   *   The main renderer service for rendering child content.
   *
   * @return bool
   *   TRUE if the plugin handled the rendering, FALSE otherwise.
   */
  public function render(array $node, array &$renderArray, string $format, ProseMirrorRenderer $renderer): bool;

  /**
   * Gets the node types this plugin can render.
   *
   * @return array
   *   Array of node type names.
   */
  public function getNodeTypes(): array;

  /**
   * Gets the supported output formats.
   *
   * @return array
   *   Array of supported format names.
   */
  public function getSupportedFormats(): array;

}
