<?php

namespace Drupal\prosemirror\Rendering;

/**
 * Interface for ProseMirror content renderers.
 */
interface ProseMirrorRendererInterface {

  /**
   * Renders ProseMirror content to the target format.
   *
   * @param array $content
   *   The ProseMirror content array.
   * @param string $format
   *   The target format (e.g., 'html', 'markdown', 'plain_text').
   *
   * @return string
   *   The rendered content.
   */
  public function render(array $content, string $format = 'html'): string;

  /**
   * Gets the supported output formats.
   *
   * @return array
   *   Array of supported format names like 'html', 'plain_text', 'markdown'.
   */
  public function getSupportedFormats(): array;

}
