const path = require('path');
const CopyWebpackPlugin = require('copy-webpack-plugin');

module.exports = {
  entry: './js/src/prosemirror.ts',
  watchOptions: {
    poll: 1_000 // Check for changes every second; required for Windows with WSL 2
  },
  plugins: [
    new CopyWebpackPlugin({
      patterns: [
        { from: 'node_modules/prosemirror-view/style/', to: '../../css/prosemirror-view/' },
        { from: 'node_modules/prosemirror-menu/style/', to: '../../css/prosemirror-menu/' },
        { from: 'node_modules/prosemirror-gapcursor/style/', to: '../../css/prosemirror-gapcursor/' },
        { from: 'node_modules/prosemirror-tables/style/', to: '../../css/prosemirror-tables/' }
      ]
    })
  ],
  module: {
    rules: [
      {
        test: /\.tsx?$/,
        use: 'ts-loader',
        include: path.resolve(__dirname, 'js/src'),
        exclude: /node_modules\/(?!prosemirror)/,
      }
    ]
  },
  resolve: {
    extensions: ['.ts', '.js'],
  },
  output: {
    filename: 'prosemirror.bundle.js',
    path: path.resolve(__dirname, 'js/dist'),
  },
  cache: true,
  mode: 'development', // 'production'
};
