# ProseMirror FontAwesome Icons

This module provides FontAwesome icon support for the ProseMirror editor as an example of the APIs.

## Features

- Adds an "Icon" button to the ProseMirror editor menu (if an *icon* element exists in the ProseMirror config)
- Provides a searchable icon picker dialog with all FontAwesome solid icons
- Supports drag-and-drop icon insertion
- Renders icons properly in both editor and output (*if allowed by the text format*)
- Demonstrates the ProseMirror APIs

## Installation

1. Enable the `prosemirror_fontawesome_icons` module
2. Add a new ProseMirror Element called "Icons", machine name "icon".
3. The module will automatically:
  - Install FontAwesome dependencies
  - Register the icon node type with ProseMirror
  - Add the icon menu item to the editor

## Usage

1. Open a ProseMirror editor
2. Click the "Icon" button in the Embed drop-down
3. Search for icons using the search field
4. Click on an icon to insert it into the editor

*Please note that icons will not render in the frontend unless the font-awesome library is included in the frontend AND the text format allows the `<i>` tag with classes.*

## Development

### Updating the JavaScript bundle

```bash
npm ci
npm run build
```

## Dependencies

- ProseMirror core module
