<?php

namespace Drupal\prosemirror_fontawesome_icons\Plugin\ProseMirror\ElementType;

use Drupal\prosemirror\Plugin\ProseMirrorElementTypeBase;

/**
 * Provides an icon element type.
 *
 * @ProseMirrorElementType(
 *   id = "icon",
 *   label = @Translation("FontAwesome Icon"),
 *   description = @Translation("A FontAwesome icon element")
 * )
 */
class IconElementType extends ProseMirrorElementTypeBase {

  /**
   * {@inheritdoc}
   */
  public function getAvailableOptions() {
    return [
      'iconName' => [
        'label' => $this->t('Icon Name'),
        'type' => 'string',
        'default' => 'camera',
        'required' => TRUE,
        'description' => $this->t('The FontAwesome icon name to display.'),
      ],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getNodeSpec(): array {
    return [
      'attrs' => [
        'iconName' => ['default' => 'camera'],
      ],
      'inline' => TRUE,
      'group' => 'inline',
      'draggable' => TRUE,
      'toDOM' => [
        'tag' => 'span',
        'attrs' => ['class' => 'font-awesome-icon'],
        'content' => FALSE,
      ],
      'parseDOM' => [
        [
          'tag' => 'span.font-awesome-icon',
          'getAttrs' => 'getIconAttrs',
        ],
      ],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function validateAttributes(array $attrs, array $path, array &$errors, array &$references): array {
    $sanitized = [];
    
    // Validate iconName attribute
    if (isset($attrs['iconName'])) {
      $iconName = (string) $attrs['iconName'];
      if (!empty($iconName)) {
        $sanitized['iconName'] = $iconName;
      } else {
        $errors[] = $this->t('Icon name is required.');
      }
    } else {
      $errors[] = $this->t('Icon name is required.');
    }
    
    return $sanitized;
  }

} 