<?php

namespace Drupal\prosemirror_fontawesome_icons\Plugin\ProseMirror\Rendering;

use Drupal\prosemirror\Plugin\ProseMirror\Rendering\ProseMirrorRenderingPluginBase;

/**
 * Provides rendering for FontAwesome icons.
 *
 * @ProseMirrorRenderingPlugin(
 *   id = "fontawesome_icons",
 *   label = @Translation("FontAwesome Icons"),
 *   description = @Translation("Renders FontAwesome icons"),
 *   elements = {"icon"}
 * )
 */
class FontAwesomeIconsRenderer extends ProseMirrorRenderingPluginBase {

  /**
   * {@inheritdoc}
   */
  public function render(array $node, array &$renderArray): bool {
    if ($node['type'] !== 'icon') {
      return FALSE;
    }

    $attrs = $node['attrs'] ?? [];
    $iconName = $attrs['iconName'] ?? '';

    if (empty($iconName)) {
      return FALSE;
    }

    $renderArray = [
      '#type' => 'html_tag',
      '#tag' => 'i',
      '#attributes' => [
        'class' => ['fas', 'fa-' . $iconName, 'pm-icon'],
        'aria-hidden' => 'true',
      ],
    ];

    return TRUE;
  }

}
