const path = require('path');

module.exports = {
  entry: './js/src/fontawesome-icons.ts',
  watchOptions: {
    poll: 1_000 // Check for changes every second; required for Windows with WSL 2
  },
  module: {
    rules: [
      {
        test: /\.tsx?$/,
        use: 'ts-loader',
        include: path.resolve(__dirname, 'js/src'),
        exclude: /node_modules\/(?!prosemirror)/,
      }
    ]
  },
  resolve: {
    extensions: ['.ts', '.js'],
  },
  output: {
    filename: 'fontawesome-icons.bundle.js',
    path: path.resolve(__dirname, 'js/dist'),
  },
  cache: true,
  mode: 'development', // 'production'
}; 