/**
 * @file
 * Dashboard JavaScript for Public APIs Integration module.
 */

(function ($, Drupal, once) {
  'use strict';

  /**
   * Dashboard functionality.
   */
  Drupal.behaviors.publicApisDashboard = {
    attach: function (context, settings) {
      once('public-apis-dashboard', '.category-card', context).forEach(function (element) {
        var $card = $(element);
        
        // Add click handler for category cards
        $card.on('click', function (e) {
          if (!$(e.target).is('a, button')) {
            var $link = $card.find('.category-actions a');
            if ($link.length) {
              window.location.href = $link.attr('href');
            }
          }
        });

        // Add hover effect
        $card.on('mouseenter', function () {
          $(this).addClass('category-card--hover');
        }).on('mouseleave', function () {
          $(this).removeClass('category-card--hover');
        });
      });

      // Add search functionality if search box exists
      once('api-search', '.api-search-box', context).forEach(function (element) {
        $(element).on('input', function () {
          var searchTerm = $(this).val().toLowerCase();
          $('.category-card').each(function () {
            var $card = $(this);
            var cardText = $card.text().toLowerCase();
            
            if (cardText.includes(searchTerm)) {
              $card.show();
            } else {
              $card.hide();
            }
          });
        });
      });

      // Initialize tooltips if they exist
      $('[data-toggle="tooltip"]', context).tooltip();
    }
  };

  /**
   * API test functionality.
   */
  Drupal.behaviors.publicApisTest = {
    attach: function (context, settings) {
      once('api-test', '.api-test-button', context).forEach(function (element) {
        $(element).on('click', function (e) {
          e.preventDefault();
          
          var $button = $(this);
          var apiUrl = $button.data('api-url');
          var $result = $button.siblings('.api-test-result');
          
          $button.prop('disabled', true).text('Testing...');
          $result.empty();
          
          $.ajax({
            url: apiUrl,
            type: 'GET',
            dataType: 'json',
            timeout: 10000,
            success: function (data) {
              $result.html('<div class="alert alert-success">API test successful!</div>');
              if (data && typeof data === 'object') {
                $result.append('<pre>' + JSON.stringify(data, null, 2) + '</pre>');
              }
            },
            error: function (xhr, status, error) {
              var message = 'API test failed: ' + (error || status);
              $result.html('<div class="alert alert-danger">' + message + '</div>');
            },
            complete: function () {
              $button.prop('disabled', false).text('Test API');
            }
          });
        });
      });
    }
  };

})(jQuery, Drupal, once);