<?php

namespace Drupal\public_consultations\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\node\NodeInterface;
use Drupal\Core\Url;
use Symfony\Component\HttpFoundation\RedirectResponse;

/**
 * Controller for handling public consultation submission redirections.
 */
class PublicConsultationsSubmissionsController extends ControllerBase {

  /**
   * Redirects to the submissions view with the node ID as a parameter.
   *
   * @param \Drupal\node\NodeInterface $node
   *   The node to get submissions for.
   *
   * @return \Symfony\Component\HttpFoundation\RedirectResponse
   *   A redirect to the submissions view.
   */
  public function redirectToSubmissions(NodeInterface $node) {
    // Create a URL to the view with the node ID as the contextual filter
    $url = Url::fromRoute('view.public_consultations_submissions.page_pc_submissions', [
      'id' => $node->id(),
    ])->toString();

    return new RedirectResponse($url);
  }

}