<?php

namespace Drupal\public_consultations\Tests\Unit;

use Drupal\Tests\UnitTestCase;

/**
 * Tests webform element redaction logic.
 */
class WebformElementRedactionTest extends UnitTestCase {

  public function testRedactedReplacesValues() {
    require_once __DIR__ . '/../../../public_consultations.module';

    $container = new \Symfony\Component\DependencyInjection\ContainerBuilder();
    $config = $this->getConfigFactoryStub(['public_consultations.settings' => [
      'redacted_text' => 'REDACTED',
    ]]);
    $container->set('config.factory', $config);
    $container->set('string_translation', $this->getStringTranslationStub());
    // Provide an entity_type.manager->getStorage('webform')->load() stub to
    // return a webform that is configured as a public consultation.
  $webform = $this->getMockBuilder('stdClass')->addMethods(['getThirdPartySetting'])->getMock();
    $webform->method('getThirdPartySetting')->with('public_consultations', 'is_public_consultation', 0)->willReturn(1);

  $storage = $this->getMockBuilder('stdClass')->addMethods(['load'])->getMock();
    $storage->method('load')->willReturn($webform);

  $entity_type_manager = $this->getMockBuilder('stdClass')->addMethods(['getStorage'])->getMock();
  $entity_type_manager->method('getStorage')->with('webform')->willReturn($storage);
    $container->set('entity_type.manager', $entity_type_manager);
    \Drupal::setContainer($container);

    // Create a minimal webform_submission-like object with get() and getData().
    $webform_submission = new class {
      public function get($key) { return new class { public function getValue() { return [['target_id' => 'test_webform']]; } }; }
      public function getData() { return []; }
    };

    // Use values that don't trigger the 'link' special-case so we get an array result.
    $variables = [
      'element' => ['#webform' => TRUE, '#redaction_settings' => 'redacted'],
      'webform_submission' => $webform_submission,
      'item' => ['value' => ['some' => 'value', 'other' => 'value2']],
    ];

    \public_consultations_preprocess_webform_element_base_html($variables);

    // If the function replaced the values with redacted text, each value should contain the redacted text.
    $this->assertIsArray($variables['item']['value']);
    foreach ($variables['item']['value'] as $v) {
      $this->assertStringContainsString('REDACTED', (string) $v);
    }
  }

  public function testHiddenUnsetsItem() {
    require_once __DIR__ . '/../../../public_consultations.module';

    $container = new \Symfony\Component\DependencyInjection\ContainerBuilder();
    $config = $this->getConfigFactoryStub([]);
    $container->set('config.factory', $config);
    $container->set('string_translation', $this->getStringTranslationStub());
    // Provide a webform that is configured as a public consultation.
  $webform = $this->getMockBuilder('stdClass')->addMethods(['getThirdPartySetting'])->getMock();
  $webform->method('getThirdPartySetting')->with('public_consultations', 'is_public_consultation', 0)->willReturn(1);
  $storage = $this->getMockBuilder('stdClass')->addMethods(['load'])->getMock();
  $storage->method('load')->willReturn($webform);
  $entity_type_manager = $this->getMockBuilder('stdClass')->addMethods(['getStorage'])->getMock();
  $entity_type_manager->method('getStorage')->with('webform')->willReturn($storage);
  $container->set('entity_type.manager', $entity_type_manager);
    \Drupal::setContainer($container);

    $webform_submission = new class {
      public function get($key) { return new class { public function getValue() { return [['target_id' => 'test_webform']]; } }; }
      public function getData() { return []; }
    };

    $variables = [
      'element' => ['#webform' => TRUE, '#redaction_settings' => 'hidden'],
      'webform_submission' => $webform_submission,
      'item' => ['value' => ['a' => 'b']],
    ];

    \public_consultations_preprocess_webform_element_base_html($variables);

    $this->assertArrayNotHasKey('item', $variables);
  }

  public function testVisibleProcessesInlineTags() {
    require_once __DIR__ . '/../../../public_consultations.module';

    $container = new \Symfony\Component\DependencyInjection\ContainerBuilder();
    $config = $this->getConfigFactoryStub(['public_consultations.settings' => ['redacted_text' => 'REDACTED']]);
    $container->set('config.factory', $config);
    $container->set('string_translation', $this->getStringTranslationStub());
  $webform = $this->getMockBuilder('stdClass')->addMethods(['getThirdPartySetting'])->getMock();
  $webform->method('getThirdPartySetting')->with('public_consultations', 'is_public_consultation', 0)->willReturn(1);
  $storage = $this->getMockBuilder('stdClass')->addMethods(['load'])->getMock();
  $storage->method('load')->willReturn($webform);
  $entity_type_manager = $this->getMockBuilder('stdClass')->addMethods(['getStorage'])->getMock();
  $entity_type_manager->method('getStorage')->with('webform')->willReturn($storage);
    $container->set('entity_type.manager', $entity_type_manager);
    \Drupal::setContainer($container);

    $webform_submission = new class {
      public function get($key) { return new class { public function getValue() { return [['target_id' => 'test_webform']]; } }; }
      public function getData() { return []; }
    };

    $variables = [
      'element' => ['#webform' => TRUE, '#redaction_settings' => 'visible'],
      'webform_submission' => $webform_submission,
      'item' => ['value' => ['desc' => 'This has <pc-redacted>secret</pc-redacted> inside']],
    ];

    \public_consultations_preprocess_webform_element_base_html($variables);

    $this->assertStringNotContainsString('secret', $variables['item']['value']['desc']);
    $this->assertStringContainsString('REDACTED', $variables['item']['value']['desc']);
  }

}
