<?php

namespace Drupal\public_consultations\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Public Consultations settings.
 */
class PublicConsultationsSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['public_consultations.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'public_consultations_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('public_consultations.settings');

    $form['ending_soon_days'] = [
      '#type' => 'number',
      '#title' => $this->t('Days threshold for "Ending Soon"'),
      '#description' => $this->t('Number of days before the end date to display the "Ending Soon" notice. Set to 0 to disable this feature.'),
      '#default_value' => $config->get('ending_soon_days') ?? 7,
      '#min' => 0,
      '#step' => 1,
    ];

    $form['ending_soon_text'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Ending Soon text'),
      '#description' => $this->t('The text to display when a consultation is ending soon. Leave empty to display no message.'),
      '#default_value' => $config->get('ending_soon_text') ?? 'Ending Soon',
      '#required' => FALSE,
    ];

    $form['closed_text'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Closed text'),
      '#description' => $this->t('The text to display when a consultation has ended. Leave empty to display no message.'),
      '#default_value' => $config->get('closed_text') ?? 'Closed',
      '#required' => FALSE,
    ];

    $form['redacted_text'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Redacted text'),
      '#description' => $this->t('The text to display for redacted content in consultations.'),
      '#default_value' => $config->get('redacted_text') ?? '██ [REDACTED] ██',
      '#required' => FALSE,
    ];

    $form['under_review_text'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Under review text'),
      '#description' => $this->t('The message to display when a submission is under review and not yet ready for public display.'),
      '#default_value' => $config->get('under_review_text') ?? 'This submission is currently under review to make it ready for public display.',
      '#required' => FALSE,
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('public_consultations.settings')
      ->set('ending_soon_days', $form_state->getValue('ending_soon_days'))
      ->set('ending_soon_text', $form_state->getValue('ending_soon_text'))
      ->set('closed_text', $form_state->getValue('closed_text'))
      ->set('redacted_text', $form_state->getValue('redacted_text'))
      ->set('under_review_text', $form_state->getValue('under_review_text'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}