<?php

namespace Drupal\public_consultations\Tests\Unit;

use Drupal\Tests\UnitTestCase;
use Drupal\public_consultations\Controller\PublicConsultationsSubmissionsController;
use Drupal\node\NodeInterface;

/**
 * Tests the redirect controller.
 */
class ControllerRedirectTest extends UnitTestCase {

  public function testRedirectToSubmissionsReturnsRedirectResponse() {
  // Initialize a minimal container to satisfy \Drupal::urlGenerator() / Url
  require_once __DIR__ . '/../../../public_consultations.module';
  $container = new \Symfony\Component\DependencyInjection\ContainerBuilder();
  // Provide a basic url_generator stub that can respond to generateFromRoute.
  $url_generator = $this->getMockBuilder('Drupal\\Core\\Routing\\UrlGeneratorInterface')->getMock();
  $url_generator->method('generateFromRoute')->willReturn('/view/public_consultations_submissions/123');
  $container->set('url_generator', $url_generator);
  \Drupal::setContainer($container);

    $node = $this->createMock(NodeInterface::class);
    $node->method('id')->willReturn(123);

    $controller = new PublicConsultationsSubmissionsController();
    $response = $controller->redirectToSubmissions($node);

    $this->assertInstanceOf('\Symfony\Component\HttpFoundation\RedirectResponse', $response);
    $this->assertIsString($response->getTargetUrl());
  }

}
