<?php

namespace Drupal\public_consultations\Tests\Unit;

use Drupal\Tests\UnitTestCase;

/**
 * Tests the field preprocess behavior for pc_end_date field.
 */
class PreprocessFieldTest extends UnitTestCase {

  public function testAddsClosedSuffix() {
    require_once __DIR__ . '/../../../public_consultations.module';

    // Build a minimal container with config.
    $container = new \Symfony\Component\DependencyInjection\ContainerBuilder();
    $config = $this->getConfigFactoryStub(['public_consultations.settings' => [
      'ending_soon_days' => 7,
      'closed_text' => 'Closed',
    ]]);
    $container->set('config.factory', $config);
    // Provide a string translation stub used by t() / TranslatableMarkup.
    $container->set('string_translation', $this->getStringTranslationStub());
    \Drupal::setContainer($container);

    $node = new class {
      public function hasField($name) { return TRUE; }
      public function get($name) { return new class { public $value = '2000-01-01'; public function isEmpty() { return FALSE; } }; }
    };

    $variables = [
      'element' => [
        '#field_name' => 'pc_end_date',
        '#entity_type' => 'node',
        '#bundle' => 'public_consultation',
        '#object' => $node,
      ],
      'items' => [
        0 => ['content' => []],
      ],
    ];

    \public_consultations_preprocess_field($variables);

    $this->assertStringContainsString('public-consultation-ending-notice-label--closed', $variables['items'][0]['content']['#suffix']);
  }

  public function testAddsEndingSoonSuffix() {
    require_once __DIR__ . '/../../../public_consultations.module';

    // Set threshold to 365 days so near future date will be within threshold.
    $container = new \Symfony\Component\DependencyInjection\ContainerBuilder();
    $config = $this->getConfigFactoryStub(['public_consultations.settings' => [
      'ending_soon_days' => 365,
      'ending_soon_text' => 'Ending Soon',
    ]]);
  $container->set('config.factory', $config);
  // Provide a string translation stub used by t() / TranslatableMarkup.
  $container->set('string_translation', $this->getStringTranslationStub());
  \Drupal::setContainer($container);

    $future = date('Y-m-d', strtotime('+30 days'));
    $node = new class($future) {
      private $future;
      public function __construct($f) { $this->future = $f; }
      public function hasField($name) { return TRUE; }
      public function get($name) { return new class($this->future) { public $value; private $f; public function __construct($f) { $this->value = $f; } public function isEmpty() { return FALSE; } }; }
    };

    $variables = [
      'element' => [
        '#field_name' => 'pc_end_date',
        '#entity_type' => 'node',
        '#bundle' => 'public_consultation',
        '#object' => $node,
      ],
      'items' => [
        0 => ['content' => []],
      ],
    ];

    \public_consultations_preprocess_field($variables);

    $this->assertStringContainsString('public-consultation-ending-notice-label--soon', $variables['items'][0]['content']['#suffix']);
  }

}
