<?php

namespace Drupal\public_consultations\Tests\Unit;

use Drupal\Tests\UnitTestCase;

/**
 * Tests node preprocess behavior for public_consultations.
 */
class PreprocessNodeTest extends UnitTestCase {

  public function testAddsClassesWhenClosed() {
    // Build a simple stub node object with required methods.
    $node = new class {
      public function getType() { return 'public_consultation'; }
      public function hasField($name) { return TRUE; }
      public function get($name) {
        return new class {
          public $value = '2000-01-01';
          public function isEmpty() { return FALSE; }
        };
      }
    };

    $variables = ['node' => $node, 'attributes' => ['class' => []]];

    // Include module and set container/config so procedural functions work.
    require_once __DIR__ . '/../../../public_consultations.module';

    // Build a minimal container and register stub services used by module.
    $container = new \Symfony\Component\DependencyInjection\ContainerBuilder();
    $config = $this->getConfigFactoryStub(['public_consultations.settings' => [
      'ending_soon_days' => 7,
      'closed_text' => 'Closed',
      'ending_soon_text' => 'Ending Soon',
    ]]);
    $container->set('config.factory', $config);
    \Drupal::setContainer($container);

    // Call the procedural preprocess function.
    \public_consultations_preprocess_node($variables);

    $this->assertArrayHasKey('is_closed', $variables);
    $this->assertContains('public-consultation-ending-notice--closed', $variables['attributes']['class']);
  }

}
