## Overview

The Public Consultations module provides a structured way to collect and manage public feedback on proposals by creating a dedicated content type that integrates with Drupal's Webform module to capture, display, and moderate submissions during defined consultation periods.

## Walkthrough Video

[https://www.youtube.com/watch?v=HwhVdpu28oo](https://www.youtube.com/watch?v=HwhVdpu28oo)

## Features

- **Public Consultation Content Type**: A dedicated content type for creating public consultation pages.
- **Date-based Consultation Period**: Define start and end dates for consultation periods.
- **Webform Integration**: Attach webforms to consultations to collect structured feedback.
- **Submission Management**: View and manage consultation submissions through a dedicated view.
- **Permission Control**: Multiple permissions to manage access to consultations and submissions.
- **Administrative Settings**: Dedicated settings page for module configuration.
- **Submission Moderation**: Tools for moderating public consultation submissions.
- **Demo Content**: Optional submodule to create demo consultations for testing.

## Requirements

- Drupal 10 or 11
- Webform module (and Webform UI)
- Pathauto module

## Installation

1. Install the module using Composer:
   ```
   composer require drupal/public_consultations
   ```

2. Enable the module through the UI or using Drush:
   ```
   drush en public_consultations
   ```

3. (Optional) Enable the demo content module for testing:
   ```
   drush en public_consultations_demo_content
   ```

## Usage

### Creating a Public Consultation

1. Go to Content > Add content > Public Consultation
2. Fill in the title and basic information about the consultation
3. Set the start and end dates for the consultation period
4. Select or create a webform to attach to the consultation
   - When creating or editing a webform, you can mark it as a public consultation by checking the "Is this a Public Consultation webform?" checkbox in the webform settings
5. Add details about the consultation in the provided field
6. Save the consultation

### Webform Element Redaction

The module provides a redaction feature for sensitive webform elements:

1. When editing a webform, navigate to the "Build" tab
2. Click on the element you want to configure for redaction
3. In the element settings, click on the 'Access' tab
4. You will have 3 options at the bottom of this tab for redaction:
   - Visible - will be visible to anyone who can view the submission
   - Redacted - will be marked [REDACTED] to anyone who can view the submission
   - Hidden - will not be show at all to anyone who can view the submission

### Managing Submissions

Submissions can be viewed in several ways:
- Through the standard Webform submissions interface
- Via the dedicated "Public Consultation Submissions" view
- Through the "Submissions" tab on consultation pages (for users with appropriate permissions)
- Administrators can moderate submissions for public display. To do so, edit any submission and click the "Ready for public display" checkbox.

### Permissions

The module provides the following permissions:
- **View redacted webform elements**: Controls who can view elements marked as redacted in public consultations
- **Administer public consultations settings**: Allows users to manage configuration settings for public consultations
- **Moderate public consultations submissions**: Allows users to moderate submissions, including approving or rejecting them for public display
- **View submissions local task**: Controls which users can see the "Submissions" tab on consultation pages

### Module Configuration

You can configure the module at Administration > Configuration > Content > Public Consultations settings.

## Customization

The module provides a standard content type and views that can be customized through the Drupal UI:

1. Customize the Public Consultation content type at Structure > Content types > Public Consultation
2. Modify the submission display at Structure > Views > Public Consultation Submissions

### Available Views

The module provides several pre-configured views:
- **Public Consultations**: Lists all public consultations with filtering options for past, current, and upcoming consultations.
- **Public Consultations Admin**: Administrative view for managing consultations.
- **Public Consultations Submissions**: Displays and manages submissions to public consultations.

## Maintainers

- Mark Conroy - [markconroy](https://drupal.org/u/markconroy)
