<?php

namespace Drupal\public_consultations\Tests\Unit;

use Drupal\Tests\UnitTestCase;

/**
 * Tests preprocess_webform_submission_data behaviour.
 */
class PreprocessWebformSubmissionDataTest extends UnitTestCase {

  public function testUnderReviewHidesElementsAndPrintsMessage() {
    require_once __DIR__ . '/../../../public_consultations.module';

    // Build a mock webform that is a public consultation
  $webform = $this->getMockBuilder('\stdClass')->addMethods(['getThirdPartySetting'])->getMock();
    $webform->expects($this->any())->method('getThirdPartySetting')->with('public_consultations', 'is_public_consultation', 0)->willReturn(1);

    // Build a stub webform submission with data not containing pc_submission_ready_for_public
  $webform_submission = $this->getMockBuilder('\stdClass')->addMethods(['getData'])->getMock();
    $webform_submission->expects($this->any())->method('getData')->willReturn([]);

    $variables = [
      'webform' => $webform,
      'webform_submission' => $webform_submission,
      'attributes' => ['class' => []],
      'elements' => ['field_a' => []],
    ];

    // Provide config with custom under_review_text
    $config = $this->getConfigFactoryStub(['public_consultations.settings' => [
      'under_review_text' => 'Under review text',
    ]]);
    $container = new \Symfony\Component\DependencyInjection\ContainerBuilder();
    $container->set('config.factory', $config);
    \Drupal::setContainer($container);

    // Capture output
    ob_start();
    \public_consultations_preprocess_webform_submission_data($variables);
    $output = ob_get_clean();

    $this->assertArrayNotHasKey('elements', $variables);
    $this->assertStringContainsString('Under review text', $output);
  }

  public function testDoesNotHideWhenReadyForPublic() {
    require_once __DIR__ . '/../../../public_consultations.module';

  $webform = $this->getMockBuilder('\stdClass')->addMethods(['getThirdPartySetting'])->getMock();
    $webform->expects($this->any())->method('getThirdPartySetting')->with('public_consultations', 'is_public_consultation', 0)->willReturn(1);

  $webform_submission = $this->getMockBuilder('\stdClass')->addMethods(['getData'])->getMock();
    $webform_submission->expects($this->any())->method('getData')->willReturn(['pc_submission_ready_for_public' => '1']);

    $variables = [
      'webform' => $webform,
      'webform_submission' => $webform_submission,
      'attributes' => ['class' => []],
      'elements' => ['field_a' => []],
    ];

    $container = new \Symfony\Component\DependencyInjection\ContainerBuilder();
    $container->set('config.factory', $this->getConfigFactoryStub(['public_consultations.settings' => []]));
    \Drupal::setContainer($container);

    ob_start();
    \public_consultations_preprocess_webform_submission_data($variables);
    $output = ob_get_clean();

    $this->assertArrayHasKey('elements', $variables);
    $this->assertEmpty($output);
  }

}
