<?php

namespace Drupal\public_consultations\Tests\Unit;

use Drupal\Tests\UnitTestCase;

/**
 * Tests views_pre_render behaviour for public_consultations.
 */
// Define a small test subclass usable by the procedural tests.
if (!class_exists('Drupal\\public_consultations\\Tests\\Unit\\TestViewExecutable')) {
  class TestViewExecutable extends \Drupal\views\ViewExecutable {
    public function __construct() {
      // Intentionally do not call parent constructor.
    }
    public function id() {
      return isset($this->id_value) ? $this->id_value : NULL;
    }
    public function setFakeId($id) {
      $this->id_value = $id;
    }
  }
}

class ViewsPreRenderTest extends UnitTestCase {

  public function testSetsTitleWhenNodePresent() {
    require_once __DIR__ . '/../../../public_consultations.module';

    // Use the lightweight TestViewExecutable so the hook type-hint is satisfied.
    $view = new \Drupal\public_consultations\Tests\Unit\TestViewExecutable();
    $view->setFakeId('public_consultations_submissions');
    $view->current_display = 'page_pc_submissions';
    $view->args = [123];

    // Mock the entityTypeManager->getStorage('node')->load behaviour.
  $node = $this->getMockBuilder('\stdClass')->addMethods(['label'])->getMock();
    $node->method('label')->willReturn('Consultation A');

  $storage = $this->getMockBuilder('\stdClass')->addMethods(['load'])->getMock();
    $storage->method('load')->with(123)->willReturn($node);

  $entity_type_manager = $this->getMockBuilder('\stdClass')->addMethods(['getStorage'])->getMock();
    $entity_type_manager->method('getStorage')->with('node')->willReturn($storage);

    // Build container and register entity_type.manager service
    $container = new \Symfony\Component\DependencyInjection\ContainerBuilder();
    $container->set('entity_type.manager', $entity_type_manager);
    // Provide a minimal string_translation service so TranslatableMarkup can
    // be converted to string during assertions. We implement minimal
    // translate/formatPlural methods without relying on an interface.
    $string_translation = new class {
      public function translate($string, array $args = [], array $options = []) {
        foreach ($args as $k => $v) {
          $string = str_replace($k, $v, $string);
        }
        return $string;
      }
      // Some Drupal code may call translateString on the string translation
      // service; provide a compatibility wrapper.
      public function translateString($string, array $args = [], array $options = []) {
        // If a TranslatableMarkup (or similar) object is passed avoid casting
        // to string (which would trigger recursion). If the object exposes
        // getUntranslatedString(), return that; otherwise cast safely.
        if (is_object($string) && method_exists($string, 'getUntranslatedString')) {
          return $string->getUntranslatedString();
        }
        return $this->translate((string) $string, $args, $options);
      }
      public function formatPlural($count, $singular, $plural, array $args = [], array $options = []) {
        return $count == 1 ? $this->translate($singular, $args, $options) : $this->translate($plural, $args, $options);
      }
    };
    $container->set('string_translation', $string_translation);
    \Drupal::setContainer($container);

  // Call the procedural function
  \public_consultations_views_pre_render($view);

  // Assert that the view title was set with the node label (stored in build_info)
  $this->assertArrayHasKey('title', $view->build_info);
  $this->assertEquals('Submissions for: Consultation A', $view->build_info['title']);
  }

  public function testDoesNotSetTitleForDifferentView() {
    require_once __DIR__ . '/../../../public_consultations.module';
    $view = new \Drupal\public_consultations\Tests\Unit\TestViewExecutable();
    $view->setFakeId('some_other_view');
    $view->current_display = 'page_pc_submissions';
    $view->args = [123];

    $container = new \Symfony\Component\DependencyInjection\ContainerBuilder();
    \Drupal::setContainer($container);

    \public_consultations_views_pre_render($view);

  $this->assertArrayNotHasKey('title', $view->build_info);
  }

}
