<?php

namespace Drupal\public_consultations\Tests\Unit;

use Drupal\Core\Access\AccessResult;
use Drupal\webform\WebformSubmissionInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Tests\UnitTestCase;

/**
 * Tests the webform submission access callback.
 */
class WebformSubmissionAccessTest extends UnitTestCase {

  protected function setUp(): void {
    parent::setUp();
    // Include the module file so procedural functions are available.
    require_once __DIR__ . '/../../../public_consultations.module';
    // Build a minimal container and register a stub config factory so
    // \Drupal::config() can be called by the procedural functions.
  $container = new \Symfony\Component\DependencyInjection\ContainerBuilder();
  $config_stub = $this->getConfigFactoryStub([]);
  $container->set('config.factory', $config_stub);
  // Provide a minimal cache contexts manager service to satisfy Cache::mergeContexts assertions.
  $cache_contexts_manager = $this->getMockBuilder('Drupal\\Core\\Cache\\Context\\CacheContextsManager')->disableOriginalConstructor()->getMock();
  $cache_contexts_manager->method('assertValidTokens')->willReturn(TRUE);
  $container->set('cache_contexts_manager', $cache_contexts_manager);
    \Drupal::setContainer($container);
  }

  public function testAnonymousDeniedForPublicConsultation() {
    $submission = $this->createMock(WebformSubmissionInterface::class);
  $webform = $this->getMockBuilder('Drupal\\webform\\WebformInterface')->getMock();
  $submission->method('getWebform')->willReturn($webform);

  // Ensure mocks provide cacheability metadata so addCacheableDependency() works.
  $submission->method('getCacheContexts')->willReturn([]);
  $submission->method('getCacheTags')->willReturn([]);
  $submission->method('getCacheMaxAge')->willReturn(NULL);

  $webform->method('getCacheContexts')->willReturn([]);
  $webform->method('getCacheTags')->willReturn([]);
  $webform->method('getCacheMaxAge')->willReturn(NULL);

  $webform->expects($this->once())->method('getThirdPartySetting')->with('public_consultations', 'is_public_consultation', 0)->willReturn(1);

    $account = $this->createMock(AccountInterface::class);
    $account->method('isAnonymous')->willReturn(TRUE);

    // Call the procedural function from the module.
    $result = \public_consultations_webform_submission_access($submission, 'view', $account);

    $this->assertInstanceOf(AccessResult::class, $result);
    $this->assertTrue($result->isForbidden());
  }

  public function testNeutralForNonViewOperation() {
    $submission = $this->createMock(WebformSubmissionInterface::class);
    $account = $this->createMock(AccountInterface::class);

    $result = \public_consultations_webform_submission_access($submission, 'edit', $account);

    $this->assertInstanceOf(AccessResult::class, $result);
    $this->assertTrue($result->isNeutral());
  }

}
