# Publish Guard

Restricts content publishing to defined time windows, helping prevent
accidental publishing during off-hours, weekends, or holidays.

## Overview

Publish Guard adds a simple safeguard to your editorial workflow by allowing
you to define when content publishing is permitted. Outside these windows,
users will either see a warning or be blocked from publishing entirely,
depending on your configuration.

## Features

- Define allowed days of the week for publishing
- Set start and end times for the daily publishing window
- Choose between "warn" mode (shows warning but allows publishing) and "block"
  mode (prevents publishing entirely)
- Customizable restriction message
- Permission-based bypass for administrators or trusted roles
- Integrates with Drupal's Help system

## Requirements

- Drupal 10.3 or 11
- PHP 8.1 or higher

## Installation

Install as you would normally install a contributed Drupal module. See the
[Drupal documentation](https://www.drupal.org/docs/extending-drupal/installing-modules)
for further information.

```bash
composer require drupal/publish_guard
drush en publish_guard
```

## Configuration

1. Navigate to **Configuration > Content authoring > Publish Guard**
   (`/admin/config/content/publish-guard`)
2. Enable publishing restrictions by checking the "Enable" checkbox
3. Select which days of the week publishing should be allowed
4. Set the start and end times for the daily publishing window
5. Choose the strictness level:
   - **Warn**: Shows a warning message but allows publishing
   - **Block**: Prevents publishing entirely
6. Optionally customize the message shown during restrictions
7. Save configuration

## Permissions

- **Administer Publish Guard**: Allows configuration of module settings
- **Bypass Publish Guard**: Allows publishing at any time regardless of
  restrictions

## How It Works

When enabled, the module checks the current time against your configured
publishing window whenever a user attempts to publish content. If the current
time falls outside the allowed window:

- In **Warn** mode: A warning message is displayed at the top of the node form,
  but the user can still publish.
- In **Block** mode: Publishing is prevented, and an error message is shown.
  Users with the "Bypass Publish Guard" permission can still publish.

## Limitations

### Already Published Content

Publish Guard only restricts the initial publishing of content. If content is
already published, users can still save changes to that content outside the
publishing window. The restriction applies when the content's status changes
from unpublished to published.

### Content Moderation

This module does not integrate with Drupal's Content Moderation module. If your
site uses editorial workflows with Content Moderation, publishing happens via
moderation state transitions (e.g., "Draft" to "Published") rather than the
standard publish status field. Publish Guard will not intercept these
transitions.

If you need time-based restrictions with Content Moderation, consider
implementing custom workflow constraints or using a different approach.

### Scheduled Publishing

Publish Guard does not integrate with the Scheduler module or similar scheduled
publishing solutions. Content scheduled for future publication will be
published at the scheduled time regardless of Publish Guard restrictions, since
the actual publishing happens via cron without user interaction.

If you need to restrict scheduled publishing, consider configuring Scheduler's
own time-based restrictions or implementing custom validation.

## Use Cases

- Prevent accidental publishing during nights or weekends when no one is
  monitoring the site
- Enforce publishing blackouts during holidays
- Add a speed bump for content changes during low-staffing periods
- Compliance requirements that restrict when content can go live

## Maintainers

- [Your Name](https://www.drupal.org/u/your-username)

## Running Tests

```bash
# Unit tests
./vendor/bin/phpunit -c core modules/custom/publish_guard/tests/src/Unit/

# Kernel tests
./vendor/bin/phpunit -c core modules/custom/publish_guard/tests/src/Kernel/
```

## License

This project is licensed under the GPL-2.0-or-later license.
