<?php

namespace Drupal\purge_users\Commands;

use Drush\Attributes as CLI;
use Drush\Commands\DrushCommands;
use Drupal\purge_users\Services\PurgeUsersPolicyServiceInterface;

/**
 * Purge users drush command using configured policies.
 */
final class PurgeUsersDrushCommands extends DrushCommands {

  /**
   * The purge policy service.
   *
   * @var \Drupal\purge_users\Services\PurgeUsersPolicyServiceInterface
   */
  protected PurgeUsersPolicyServiceInterface $policyService;

  public function __construct(PurgeUsersPolicyServiceInterface $policy_service) {
    parent::__construct();
    $this->policyService = $policy_service;
  }

  /**
   * Drush command to purge users based on configured policies.
   */
  #[CLI\Command(name: 'purge-users:purge', aliases: ['pu:purge', 'purge-users'])]
  #[CLI\Option(name: 'dry-run', description: 'Simulate the purge without deleting or canceling users')]
  #[CLI\Topics(topics: ['purge-users'])]
  public function purge(array $options = ['dry-run' => FALSE]): void {
    $dry_run = $options['dry-run'];
    $result = $this->policyService->purgeAllUsers(FALSE, $dry_run);
    $this->output()->writeln($result . ' users queued for purge.');
  }

  /**
   * Drush command to notify users before deletion based on configured policies.
   */
  #[CLI\Command(name: 'purge-users:notify', aliases: ['pu:notify', 'purge-notify'])]
  #[CLI\Topics(topics: ['purge-users'])]
  public function notify(): void {
    $result = $this->policyService->notifyAllUsers();
    $this->output()->writeln($result . ' users queued for notification.');
  }

}
