<?php

namespace Drupal\purge_users\Form;

use Drupal\Core\Form\FormStateInterface;

/**
 * The definition of the purge users policy form.
 */
class PurgeUsersPolicyAddForm extends PurgeUsersPolicyForm {

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state) {
    $status = parent::save($form, $form_state);

    if ($status) {
      $this->messenger()->addMessage($this->t('The purge users policy %label has been added.', [
        '%label' => $this->entity->label(),
      ]));
    }
    else {
      $this->messenger()->addMessage($this->t('The purge users policy was not saved.'));
    }

    $form_state->setRedirect('entity.purge_users_policy.edit_form', [
      'purge_users_policy' => $this->entity->id(),
    ]);
    return $status;
  }

}
