<?php

declare(strict_types=1);

namespace Drupal\purge_users\Plugin\BatchWorker;

use Drupal\user\Entity\User;

/**
 * Purge user and notify.
 *
 * @package Drupal\purge_users\Plugin\BatchWorker
 */
class BatchWorker {

  /**
   * Process items in a batch.
   */
  public static function batchWorkerPurgeUsers($id, $policy, $dry_run, &$context): void {
    $account = User::load($id);
    if (!isset($context['results']['processed'])) {
      $context['results']['processed'] = 0;
    }
    if (!isset($context['results']['purged'])) {
      $context['results']['purged'] = 0;
    }
    /** @var \Drupal\purge_users\Services\UserManagementServiceInterface $userManagement */
    $userManagement = \Drupal::service('purge_users.user_management');
    $userManagement->purgeUser($account, $policy, $dry_run);
    $name = $account->get('name')->value;
    $context['message'] = "Now processing $name ...";

    // Update our progress information.
    $context['results']['processed']++;
    $context['results']['purged']++;
  }

  /**
   * Sends users pre-notifications in a batch.
   */
  public static function batchWorkerNotifyUsers($id, $policy, &$context): void {
    $account = User::load($id);
    if (!isset($context['results']['processed'])) {
      $context['results']['processed'] = 0;
    }
    if (!isset($context['results']['notified'])) {
      $context['results']['notified'] = 0;
    }
    // Update our progress information.
    $context['results']['processed']++;
    if (!$account) {
      return;
    }
    $name = $account->get('name')->value;
    /** @var \Drupal\purge_users\Services\UserManagementServiceInterface $userManagement */
    $userManagement = \Drupal::service('purge_users.user_management');
    $userManagement->notifyUser($account, $policy);
    $context['message'] = "$name notified.";
    $context['results']['notified']++;
  }

}
