<?php

namespace Drupal\purge_users\Plugin\Condition;

use Drupal\purge_users\Entity\PurgeUsersPolicy;

/**
 * Utility functions for policy conditions.
 */
trait PolicyConditionTrait {

  /**
   * Get the notification delay string.
   *
   * @param \Drupal\purge_users\Entity\PurgeUsersPolicy $policy
   *   The policy.
   *
   * @return string
   *   The notification string.
   */
  protected function getPolicyNotificationString(PurgeUsersPolicy $policy) {
    $user_before_notification_value = $policy->get('user_before_notification_value');
    $user_before_notification_period = $policy->get('user_before_notification_period');
    return $user_before_notification_value . ' ' . $user_before_notification_period;
  }

  /**
   * Add notification delay to date.
   *
   * @param \Drupal\purge_users\Entity\PurgeUsersPolicy $policy
   *   The policy.
   * @param int|null $date
   *   The date to updated.
   *
   * @return int
   *   The notification time.
   */
  protected function addPolicyNotificationDelay(PurgeUsersPolicy $policy, ?int $date = NULL): int {
    return strtotime('+' . $this->getPolicyNotificationString($policy), $date);
  }

  /**
   * Subtract notification delay to date.
   *
   * @param \Drupal\purge_users\Entity\PurgeUsersPolicy $policy
   *   The policy.
   * @param int|null $date
   *   The date to updated.
   *
   * @return int
   *   The notification time.
   */
  protected function subtractPolicyNotificationDelay(PurgeUsersPolicy $policy, ?int $date = NULL): int {
    return strtotime('-' . $this->getPolicyNotificationString($policy), $date);
  }

}
