<?php

namespace Drupal\purge_users;

use Drupal\Core\Condition\ConditionPluginBase;

/**
 * A base class to define standard operations of a purge users policy condition.
 */
abstract class PurgeUsersConditionBase extends ConditionPluginBase implements PurgeUsersConditionInterface {

  /**
   * {@inheritdoc}
   */
  public function getLabel() {
    return $this->pluginDefinition['label'];
  }

  /**
   * {@inheritdoc}
   */
  public function isStatusRelated() {
    return $this->pluginDefinition['status_related'] ?? FALSE;
  }

}
