<?php

namespace Drupal\purge_users;

use Drupal\Core\Condition\ConditionInterface;

/**
 * An interface to define the expected operations of a purge users condition.
 */
interface PurgeUsersConditionInterface extends ConditionInterface {

  /**
   * Returns a translated string for the condition label.
   *
   * @return string
   *   Label of the condition.
   */
  public function getLabel();

  /**
   * Indicates that this condition is related to the status of the user.
   *
   * @return bool
   *   TRUE if the condition is related to user status.
   */
  public function isStatusRelated();

}
