<?php

namespace Drupal\purge_users;

use Drupal\Core\Config\Entity\ConfigEntityInterface;

/**
 * Provides an interface defining a purge users policy entity.
 */
interface PurgeUsersPolicyInterface extends ConfigEntityInterface {

  /**
   * Return the conditions from the policy.
   *
   * @return array
   *   All condition configurations for the policy.
   */
  public function getConditions();

  /**
   * Return a specific condition from the policy.
   *
   * @param string $key
   *   The condition ID from the individual policy configuration.
   *
   * @return array
   *   A specific condition configuration in the policy.
   */
  public function getCondition($key);

}
