<?php

namespace Drupal\purge_users\Services;

use Drupal\purge_users\Entity\PurgeUsersPolicy;

/**
 * Contract for the purge users policy service.
 */
interface PurgeUsersPolicyServiceInterface {

  /**
   * Clear purge and notify queues.
   *
   * Used on configuration updates.
   *
   * @see https://www.drupal.org/project/purge_users/issues/3188473
   */
  public function clearQueues();

  /**
   * Purge all users of all policies.
   */
  public function purgeAllUsers(bool $cron = FALSE, bool $dry_run = FALSE): int;

  /**
   * Notify all users of all policies.
   */
  public function notifyAllUsers(): int;

  /**
   * Purge users for a specific policy.
   *
   * @param \Drupal\purge_users\Entity\PurgeUsersPolicy $policy
   *   The user to block.
   */
  public function getPolicyUserIdsToPurge(PurgeUsersPolicy $policy): array;

  /**
   * Notify users for a specific policy.
   *
   * @param \Drupal\purge_users\Entity\PurgeUsersPolicy $policy
   *   The user to block.
   */
  public function getPolicyUserIdsToNotify(PurgeUsersPolicy $policy): array;

}
