<?php

declare(strict_types=1);

namespace Drupal\Tests\purge_users\Functional\policy;

use Drupal\Tests\purge_users\Functional\BlockedDeleteTest;

/**
 * Purge users who have been blocked for a specific period.
 *
 * - Purge method: Delete the account and its content.
 * - Disregard inactive/blocked users unselected.
 * - User Deletion Notification unselected.
 *
 * @group purge_users
 */
class PolicyBlockedDeleteTest extends BlockedDeleteTest {

  /**
   * {@inheritdoc}
   */
  protected function setUpConfig(): void {
    // Set the basic configuration.
    $this->setBasicConfig();
    // Set up the test policy configuration.
    $policy = $this->setBasicPolicyConfig();
    $conditions = $policy->getConditions();
    $conditions[] = [
      'id' => 'purge_users:blocked',
      'user_blocked_value' => '100',
      'user_blocked_period' => 'days',
    ];
    $policy->set('policy_conditions', $conditions);
    $policy->save();
  }

}
