<?php

declare(strict_types=1);

namespace Drupal\Tests\purge_users\Functional\policy;

use Drupal\Tests\purge_users\Functional\ContentAuthorDeleteTest;

/**
 * Do not purge users who have contributed contents.
 *
 * - Purge method: Delete the account and its content.
 * - Disregard inactive/blocked users unselected.
 * - User Deletion Notification unselected.
 *
 * @group purge_users
 */
class PolicyContentAuthorDeleteTest extends ContentAuthorDeleteTest {

  /**
   * Setup configuration for the test.
   */
  protected function setUpConfig(): void {
    // Set the basic configuration and add the specific changes.
    $this->setBasicConfig();

    // Set up the test policies' configuration.
    $blocked_author_policy = $this->setBasicPolicyConfig('blocked_author_policy');
    $conditions = $blocked_author_policy->getConditions();
    $conditions[] = [
      'id' => 'purge_users:blocked',
      'user_blocked_value' => '100',
      'user_blocked_period' => 'days',
    ];
    $conditions[] = [
      'id' => 'purge_users:author_commenter',
      'enabled_do_not_purge_authors' => TRUE,
    ];
    $blocked_author_policy->set('policy_conditions', $conditions);
    $blocked_author_policy->save();

    $not_logged_in_author_policy = $this->setBasicPolicyConfig('not_logged_in_author_policy');
    $conditions = $not_logged_in_author_policy->getConditions();
    $conditions[] = [
      'id' => 'purge_users:not_logged_in',
      'user_lastlogin_value' => '10',
      'user_lastlogin_period' => 'month',
    ];
    $conditions[] = [
      'id' => 'purge_users:author_commenter',
      'enabled_do_not_purge_authors' => TRUE,
    ];
    $not_logged_in_author_policy->set('policy_conditions', $conditions);
    $not_logged_in_author_policy->save();
  }

}
