<?php

declare(strict_types=1);

namespace Drupal\Tests\purge_users\Functional\policy;

use Drupal\Tests\purge_users\Functional\InactiveDeleteTest;

/**
 * Purge users whose account has not been activated for a specific period.
 *
 * - Purge method: Delete the account and its content.
 * - Disregard inactive/blocked users unselected.
 * - User Deletion Notification unselected.
 *
 * @group purge_users
 */
class PolicyInactiveDeleteTest extends InactiveDeleteTest {

  /**
   * Setup configuration for the test.
   */
  protected function setUpConfig(): void {
    // Set the basic configuration and add the specific changes.
    $this->setBasicConfig();
    // Set up the test policy configuration.
    $policy = $this->setBasicPolicyConfig();
    $conditions = $policy->getConditions();
    $conditions[] = [
      'id' => 'purge_users:inactive',
      'user_inactive_value' => '1',
      'user_inactive_period' => 'year',
    ];
    $policy->set('policy_conditions', $conditions);
    $policy->save();
  }

}
